iowa.lm1 <- lm(Yield ~ ., Iowa)
iowa.step <- stepAIC(iowa.lm1, scope = list(lower = ~ Year,
	upper = ~.), k = log(nrow(Iowa)), trace = F)
dropterm(iowa.step, test = "F", k = log(nrow(Iowa)), sorted = T)

library(mgcv)
iowa.gam <- gam(Yield ~ s(Temp4,k=5) + s(Rain0,k=5) +
                        s(Rain2,k=5) + s(Year,k=5),
	data = Iowa, trace=T)

par(mfrow = c(2,2))
plot(iowa.gam, se = T, ylim = c(-30, 30), resid = TRUE)
par(mfrow = c(2,2))
plot(iowa.gam, se = T,  resid = T)
summary(iowa.gam)

library(splines)
iowa.ns <- lm(Yield ~ ns(Temp4, df=3) + ns(Rain0, df=3) + ns(Rain2, df = 3) + ns(Year, df=3), Iowa)
tplot(iowa.ns, se=T, partial.resid = T, rug = T)
dropterm(iowa.ns, test = "F", k = log(nrow(Iowa)))

# 8.8  Additive models

rock.lm <- lm(log(perm) ~ area + peri + shape, data = rock)
summary(rock.lm)
rock.gam <- gam(log(perm) ~ s(area) + s(peri) + s(shape),
  control = gam.control(maxit = 50), data = rock)
summary(rock.gam)
anova(rock.lm, rock.gam)
par(mfrow = c(2, 3), pty = "s")
plot(rock.gam, se = T, resid = T)
rock.gam1 <- gam(log(perm) ~ area + peri + s(shape), data = rock)
summary(rock.gam1)
anova(rock.gam1)

plot(rock.gam1, se = T, all.terms = T, resid = T)
anova(rock.lm, rock.gam1, rock.gam)

